require( "scripts/style.lua" );

igButtonFontWhite = {
  bigButtonFont,
  30,--18,
  WhiteColor
};

kButtonSpacing = 60;    -- Put our buttons 60 pixels apart
kButtonY = kCenter-155;  -- Three buttons means center 60 pixels above the center

if( PauseGame~=nil)then
    PauseGame();
end

MakeDialog
{
    -- Name the modal dialog
    name="pausemenu",
    Bitmap
    {
        image="backgrounds/ingamemenu",
        x=kCenter,
        y=kCenter,

        SetStyle(ButtonStyle),
        Button
        {
            x=kCenter,
            y=kButtonY,
            label="resume",
            graphics = StButtonGraphicsMidBig,            
            font = igButtonFontWhite;
            close = true,   -- Just close this window
            sound=kDefaultButtonSound,                        
            command=
                function()
                    -- Pop up an options screen
                    if( ResumeGame ~= nil)then
                        ResumeGame();
                    end
                end         
        },
        
        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 1),
            label="restart",
            graphics = StButtonGraphicsMidBig,            
            font = igButtonFontWhite;
            sound=kDefaultButtonSound,                        
            command=
                function()
                    local isMinigame1 = isMinigame;    
                    if StopGame then StopGame(0);end;
                    PopModal("pausemenu");
                    if(isMinigame1)then 
                        PopModal("bonus_dialog");                        
                    end;
					--       -   
					CheckLoadingWindow(); 
                    LoadLevel(gGlobalPlayerInfo.gLevelNum);
                end         
        },
        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 2),
            label="options",
            graphics = StButtonGraphicsMidBig,            
            sound=kDefaultButtonSound,                        
            font = igButtonFontWhite;
            command=
                function()
                    -- Pop up an options screen
                    DoModal("scripts/options.lua");
                end
        },
        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 3),
            label="back_to_menu",
            --close = true,   -- Just close this window
            graphics = StButtonGraphicsMidBig,        
            sound=kDefaultButtonSound,            
            font = igButtonFontWhite;
            command=
                function()
                    -- Pop up an options screen
                    -- SendGameMessage( "quit" );
                    result = DisplayDialog { 
                        "scripts/yesno.lua", 
                        body ="confirm_quit_level",
                        title = "empty_text" 
                    };
                    if (result=='yes') then
                    
                        local isMinigame1 = isMinigame;    
                        if StopGame then StopGame(1); end;
                        
						PopModal("pausemenu");
						
						if( isMinigame1 == 1)then
							PopModal("bonus_dialog");
                        end
						--       -   
						CheckLoadingWindow(); 
                        
                        if (gGameMode == 0)  then
                            DoModal("scripts/game_map.lua");
                        else
                            DoModal("scripts/game_map_endless.lua");
                        end
						
						
                    end
                end
        },
        
        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 4),
            label="help",
            graphics = StButtonGraphicsMidBig,            
            font = igButtonFontWhite;
            sound=kDefaultButtonSound,                        
            command=
                function()
                    -- Pop up an options screen
                    DoModal("scripts/help.lua");
                end
        },
        Button
        {
            x=kCenter,
            y=kButtonY + (kButtonSpacing * 5),
            label="quit",
            graphics = StButtonGraphicsMidBig,            
            font = igButtonFontWhite;
            sound=kDefaultButtonSound,                        
            command=
                function()
                    -- Our game provides this call--it's not a Playground
                    -- call.
                    result = DisplayDialog { 
                        "scripts/yesno.lua", 
                        body ="confirm_quit_level",
                        title = "empty_text" 
                    };
                    if (result=='yes') then
                        
                        if StopGame then StopGame(1); end
                        SendGameMessage( "quit" );
                    end
                end
        },
    },
}